/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.i.NonArtifactCreaturesDiedWatcher;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class InsatiableRakghoulEffect
extends OneShotEffect {
    InsatiableRakghoulEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "with a +1/+1 counter on it if a non-artifact creature died this turn";
    }

    private InsatiableRakghoulEffect(InsatiableRakghoulEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent permanent;
            NonArtifactCreaturesDiedWatcher watcher = (NonArtifactCreaturesDiedWatcher)game.getState().getWatcher(NonArtifactCreaturesDiedWatcher.class);
            if (watcher != null && watcher.conditionMet() && (permanent = game.getPermanentEntering(source.getSourceId())) != null) {
                permanent.addCounters(CounterType.P1P1.createInstance(1), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public InsatiableRakghoulEffect copy() {
        return new InsatiableRakghoulEffect(this);
    }
}

