/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.i.InsistWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class InsistEffect
extends ContinuousRuleModifyingEffectImpl {
    InsistEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next creature spell you cast this turn can't be countered";
    }

    private InsistEffect(InsistEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public InsistEffect copy() {
        return new InsistEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        InsistWatcher watcher = (InsistWatcher)game.getState().getWatcher(InsistWatcher.class, source.getControllerId());
        if (watcher != null) {
            watcher.setReady();
        }
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            return "This spell can't be countered (" + sourceObject.getName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        InsistWatcher watcher = (InsistWatcher)game.getState().getWatcher(InsistWatcher.class, source.getControllerId());
        return spell != null && watcher != null && watcher.isUncounterable(spell.getId());
    }
}

