/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class InsultDoubleDamageEffect
extends ReplacementEffectImpl {
    InsultDoubleDamageEffect() {
        super(Duration.EndOfTurn, Outcome.Damage);
        this.staticText = "If a source you control would deal damage this turn, it deals double that damage instead.";
    }

    private InsultDoubleDamageEffect(InsultDoubleDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public InsultDoubleDamageEffect copy() {
        return new InsultDoubleDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PLAYER || event.getType() == GameEvent.EventType.DAMAGE_PERMANENT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getControllerId(event.getSourceId()).equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

