/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InsurrectionEffect
extends OneShotEffect {
    InsurrectionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Untap all creatures and gain control of them until end of turn. They gain haste until end of turn";
    }

    private InsurrectionEffect(InsurrectionEffect effect) {
        super((OneShotEffect)effect);
    }

    public InsurrectionEffect copy() {
        return new InsurrectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        GainControlTargetEffect gainControl = new GainControlTargetEffect(Duration.EndOfTurn);
        GainAbilityTargetEffect gainHaste = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            creature.untap(game);
            gainControl.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            gainHaste.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), game));
            game.addEffect((ContinuousEffect)gainControl, source);
            game.addEffect((ContinuousEffect)gainHaste, source);
        }
        return true;
    }
}

