/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class IntellectualOfferingDrawEffect
extends OneShotEffect {
    IntellectualOfferingDrawEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Choose an opponent. You and that player each draw three cards";
    }

    private IntellectualOfferingDrawEffect(IntellectualOfferingDrawEffect effect) {
        super((OneShotEffect)effect);
    }

    public IntellectualOfferingDrawEffect copy() {
        return new IntellectualOfferingDrawEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetOpponent target = new TargetOpponent(true);
            target.choose(Outcome.DrawCard, source.getControllerId(), source.getSourceId(), source, game);
            player.drawCards(3, source, game);
            Player opponent = game.getPlayer(target.getFirstTarget());
            if (opponent != null) {
                opponent.drawCards(3, source, game);
                return true;
            }
        }
        return false;
    }
}

