/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class InterpretTheSignsEffect
extends OneShotEffect {
    InterpretTheSignsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "scry 3, then reveal the top card of your library. Draw cards equal to that card's mana value";
    }

    private InterpretTheSignsEffect(InterpretTheSignsEffect effect) {
        super((OneShotEffect)effect);
    }

    public InterpretTheSignsEffect copy() {
        return new InterpretTheSignsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        controller.scry(3, source, game);
        Card card = controller.getLibrary().getFromTop(game);
        if (card == null) {
            return true;
        }
        controller.revealCards(source, (Cards)new CardsImpl(card), game);
        controller.drawCards(card.getManaValue(), source, game);
        return true;
    }
}

