/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class InvasionOfAlaraEffect
extends OneShotEffect {
    InvasionOfAlaraEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile cards from the top of your library until you exile two nonland cards with mana value 4 or less. You may cast one of those two cards without paying its mana cost. Put one of them into your hand. Then put the other cards exiled this way on the bottom of your library in a random order";
    }

    private InvasionOfAlaraEffect(InvasionOfAlaraEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfAlaraEffect copy() {
        return new InvasionOfAlaraEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        CardsImpl castable = new CardsImpl();
        int count = 0;
        for (Card card : player.getLibrary().getCards(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            cards.add(card);
            if (!card.isLand(game) && card.getManaValue() <= 4) {
                castable.add(card);
                ++count;
            }
            if (count < 2) continue;
            break;
        }
        CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)castable, (FilterCard)StaticFilters.FILTER_CARD);
        castable.retainZone(Zone.EXILED, game);
        if (castable.size() > 1) {
            TargetCardInExile target = new TargetCardInExile(StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            player.choose(this.outcome, (Cards)castable, (TargetCard)target, source, game);
            player.moveCards(game.getCard(target.getFirstTarget()), Zone.HAND, source, game);
        } else {
            player.moveCards((Cards)castable, Zone.HAND, source, game);
        }
        cards.retainZone(Zone.EXILED, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

