/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.ModalDoubleFacedCard;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class InvasionOfPyruleaEffect
extends OneShotEffect {
    InvasionOfPyruleaEffect() {
        super(Outcome.Benefit);
        this.staticText = "scry 3, then reveal the top card of your library. If it's a land or double-faced card, draw a card";
    }

    private InvasionOfPyruleaEffect(InvasionOfPyruleaEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvasionOfPyruleaEffect copy() {
        return new InvasionOfPyruleaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.scry(3, source, game);
        Card card = player.getLibrary().getFromTop(game);
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card != null && (card.isLand(game) || card instanceof ModalDoubleFacedCard || card.getSecondCardFace() != null)) {
            player.drawCards(1, source, game);
        }
        return true;
    }
}

