/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SwitchPowerToughnessTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InvertEffect
extends OneShotEffect {
    InvertEffect() {
        super(Outcome.Benefit);
        this.staticText = "Switch the power and toughness of each of up to two target creatures until end of turn.";
    }

    private InvertEffect(InvertEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvertEffect copy() {
        return new InvertEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            SwitchPowerToughnessTargetEffect effect = new SwitchPowerToughnessTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(targetId, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

