/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

enum InvestigatorsJournalValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int greatestCreatureCount = 0;
        for (UUID playerId : game.getState().getPlayersInRange(sourceAbility.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            greatestCreatureCount = Math.max(greatestCreatureCount, game.getBattlefield().countAll((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game));
        }
        return greatestCreatureCount;
    }

    public InvestigatorsJournalValue copy() {
        return instance;
    }

    public String toString() {
        return "X";
    }

    public String getMessage() {
        return "greatest number of creatures a player controls";
    }
}

