/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetPermanentAmount;
import mage.target.targetpointer.SecondTargetPointer;
import mage.target.targetpointer.TargetPointer;

class InvokeJusticeEffect
extends OneShotEffect {
    InvokeJusticeEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then distribute four +1/+1 counters among any number of creatures and/or Vehicles target player controls";
        this.setTargetPointer((TargetPointer)new SecondTargetPointer());
    }

    private InvokeJusticeEffect(InvokeJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public InvokeJusticeEffect copy() {
        return new InvokeJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        FilterPermanent filter = new FilterPermanent("creatures and/or Vehicles " + player.getName() + " controls");
        filter.add(Predicates.or((Predicate)CardType.CREATURE.getPredicate(), (Predicate)SubType.VEHICLE.getPredicate()));
        filter.add((Predicate)new ControllerIdPredicate(player.getId()));
        if (!game.getBattlefield().contains(filter, source, game, 1)) {
            return false;
        }
        TargetPermanentAmount target = new TargetPermanentAmount(4, 0, filter);
        target.withNotTarget(true);
        target.chooseTarget(this.outcome, player.getId(), source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(target.getTargetAmount(targetId)), source, game);
        }
        return true;
    }
}

