/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class InzervaMasterOfInsightsEffect
extends OneShotEffect {
    InzervaMasterOfInsightsEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at the top two cards of each other player's library, then put any number of them on the bottom of that library and the rest on top in any order";
    }

    private InzervaMasterOfInsightsEffect(InzervaMasterOfInsightsEffect effect) {
        super((OneShotEffect)effect);
    }

    public InzervaMasterOfInsightsEffect copy() {
        return new InzervaMasterOfInsightsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player opponent = game.getPlayer(playerId);
                if (playerId.equals(controller.getId()) || opponent == null) continue;
                CardsImpl cards = new CardsImpl();
                int count = Math.min(2, opponent.getLibrary().size());
                if (count == 0) continue;
                for (int i = 0; i < count; ++i) {
                    Card card = opponent.getLibrary().removeFromTop(game);
                    cards.add(card);
                }
                TargetCard targets = new TargetCard(0, cards.size(), Zone.LIBRARY, new FilterCard("cards to PUT on the BOTTOM of " + opponent.getName() + "'s library"));
                controller.chooseTarget(Outcome.Neutral, (Cards)cards, targets, source, game);
                if (!controller.canRespond() || !opponent.canRespond()) continue;
                controller.putCardsOnBottomOfLibrary((Cards)new CardsImpl((Collection)targets.getTargets()), game, source, true);
                cards.removeIf(targets.getTargets()::contains);
                controller.putCardsOnTopOfLibrary((Cards)cards, game, source, true);
            }
            return true;
        }
        return false;
    }
}

