/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IonasBlessingEffect
extends ContinuousEffectImpl {
    IonasBlessingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = ", and can block an additional creature each combat";
    }

    private IonasBlessingEffect(IonasBlessingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public IonasBlessingEffect copy() {
        return new IonasBlessingEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchanted;
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm != null && perm.getAttachedTo() != null && (enchanted = game.getPermanent(perm.getAttachedTo())) != null) {
            switch (layer) {
                case RulesEffects: {
                    if (enchanted.getMaxBlocks() <= 0) break;
                    enchanted.setMaxBlocks(enchanted.getMaxBlocks() + 1);
                }
            }
            return true;
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.RulesEffects;
    }
}

