/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class IonizeEffect
extends OneShotEffect {
    IonizeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Counter target spell. {this} deals 2 damage to that spell's controller.";
    }

    private IonizeEffect(IonizeEffect effect) {
        super((OneShotEffect)effect);
    }

    public IonizeEffect copy() {
        return new IonizeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean result = false;
        Spell spell = game.getStack().getSpell(source.getFirstTarget());
        if (spell != null) {
            Player spellController = game.getPlayer(spell.getControllerId());
            result = game.getStack().counter(source.getFirstTarget(), source, game);
            if (spellController != null) {
                spellController.damage(2, source.getSourceId(), source, game);
            }
        }
        return result;
    }
}

