/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.common.CastSpellLastTurnWatcher;

class IrencragFeatCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    private final int start;

    IrencragFeatCantCastEffect(int start) {
        super(Duration.EndOfTurn, Outcome.Detriment);
        this.start = start;
    }

    private IrencragFeatCantCastEffect(IrencragFeatCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.start = effect.start;
    }

    public IrencragFeatCantCastEffect copy() {
        return new IrencragFeatCantCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        CastSpellLastTurnWatcher watcher = (CastSpellLastTurnWatcher)game.getState().getWatcher(CastSpellLastTurnWatcher.class);
        int spellsCast = watcher.getAmountOfSpellsPlayerCastOnCurrentTurn(source.getControllerId());
        return event.getPlayerId().equals(source.getControllerId()) && spellsCast > this.start;
    }
}

