/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.predicate.card.AuraCardCanAttachToPermanentId;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class IridescentDrakeEffect
extends OneShotEffect {
    IridescentDrakeEffect() {
        super(Outcome.Benefit);
        this.staticText = "put target Aura card from a graveyard onto the battlefield under your control attached to {this}";
    }

    private IridescentDrakeEffect(IridescentDrakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public IridescentDrakeEffect copy() {
        return new IridescentDrakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Target target;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        Card targetAuraCard = game.getCard(source.getFirstTarget());
        if (controller != null && permanent != null && controller.canRespond() && targetAuraCard != null && new AuraCardCanAttachToPermanentId(permanent.getId()).apply(targetAuraCard, game) && (target = (Target)targetAuraCard.getSpellAbility().getTargets().get(0)) != null) {
            game.getState().setValue("attachTo:" + targetAuraCard.getId(), (Object)permanent);
            controller.moveCards(targetAuraCard, Zone.BATTLEFIELD, source, game);
            return permanent.addAttachment(targetAuraCard.getId(), source, game);
        }
        return false;
    }
}

