/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IronApprenticeEffect
extends OneShotEffect {
    IronApprenticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "put those counters on target creature you control";
    }

    private IronApprenticeEffect(IronApprenticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public IronApprenticeEffect copy() {
        return new IronApprenticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentLeftBattlefield");
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (permanent == null || creature == null) {
            return false;
        }
        permanent.getCounters(game).copy().values().forEach(counter -> creature.addCounters(counter, source, game));
        return true;
    }
}

