/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.i.IsolationCellEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IsolationCellTriggeredAbility
extends TriggeredAbilityImpl {
    public IsolationCellTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new IsolationCellEffect(), false);
    }

    private IsolationCellTriggeredAbility(IsolationCellTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public IsolationCellTriggeredAbility copy() {
        return new IsolationCellTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Card card;
        if (game.getOpponents(this.controllerId).contains(event.getPlayerId()) && (card = game.getCard(event.getSourceId())) != null && card.isCreature(game)) {
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever an opponent casts a creature spell, that player loses 2 life unless they pay {2}.";
    }
}

