/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class IvoryTowerEffect
extends OneShotEffect {
    IvoryTowerEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain X life, where X is the number of cards in your hand minus 4.";
    }

    private IvoryTowerEffect(IvoryTowerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int amount = player.getHand().size() - 4;
            if (amount > 0) {
                player.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }

    public IvoryTowerEffect copy() {
        return new IvoryTowerEffect(this);
    }
}

