/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class IxhelScionOfAtraxaEffect
extends OneShotEffect {
    IxhelScionOfAtraxaEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent who has three or more poison counters exiles the top card of their library face down. You may look at and play those cards for as long as they remain exiled, and you may spend mana as though it were mana of any color to cast those spells";
    }

    private IxhelScionOfAtraxaEffect(IxhelScionOfAtraxaEffect effect) {
        super((OneShotEffect)effect);
    }

    public IxhelScionOfAtraxaEffect copy() {
        return new IxhelScionOfAtraxaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        for (UUID opponentId : game.getOpponents(source.getControllerId(), true)) {
            Card card;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getCountersCount(CounterType.POISON) < 3 || !opponent.getLibrary().hasCards() || (card = opponent.getLibrary().getFromTop(game)) == null) continue;
            cards.add(card);
        }
        if (cards.isEmpty()) {
            return false;
        }
        return new ExileFaceDownYouMayPlayAsLongAsExiledTargetEffect(false, CastManaAdjustment.AS_THOUGH_ANY_MANA_COLOR).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)).apply(game, source);
    }
}

