/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class IzzetChemisterCastFromExileEffect
extends OneShotEffect {
    IzzetChemisterCastFromExileEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "cast any number of cards exiled with {this} without paying their mana costs";
    }

    private IzzetChemisterCastFromExileEffect(IzzetChemisterCastFromExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IzzetChemisterCastFromExileEffect copy() {
        return new IzzetChemisterCastFromExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        ExileZone exile = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)source));
        if (controller == null || exile == null || exile.isEmpty()) {
            return false;
        }
        CardUtil.castMultipleWithAttributeForFree((Player)controller, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)exile), (FilterCard)StaticFilters.FILTER_CARD);
        return true;
    }
}

