/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class IzzetGeneratoriumReplacementEffect
extends ReplacementEffectImpl {
    IzzetGeneratoriumReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "if you would get one or more {E}, you get that many plus one {E} instead";
    }

    private IzzetGeneratoriumReplacementEffect(IzzetGeneratoriumReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmountForCounters(CardUtil.overflowInc((int)event.getAmount(), (int)1), true);
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADD_COUNTERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return source.isControlledBy(event.getTargetId()) && CounterType.ENERGY.getName().equals(event.getData()) && event.getAmount() > 0;
    }

    public IzzetGeneratoriumReplacementEffect copy() {
        return new IzzetGeneratoriumReplacementEffect(this);
    }
}

