/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.HunterToken;
import mage.game.permanent.token.Token;
import mage.players.Player;

class JabbaTheHuttEffect
extends OneShotEffect {
    JabbaTheHuttEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create a tapped 4/4 red Hunter creature token. It fights another target creature an opponent control with a bounty counter on it";
    }

    private JabbaTheHuttEffect(JabbaTheHuttEffect effect) {
        super((OneShotEffect)effect);
    }

    public JabbaTheHuttEffect copy() {
        return new JabbaTheHuttEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new HunterToken(), 1, true, false);
            effect.apply(game, source);
            Permanent token = game.getPermanent((UUID)effect.getLastAddedTokenIds().get(0));
            Permanent opponentCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (token != null && opponentCreature != null) {
                return token.fight(opponentCreature, source, game);
            }
        }
        return false;
    }
}

