/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawDiscardControllerEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForOnePlayerEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class JaceCunningCastawayDamageTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    JaceCunningCastawayDamageTriggeredAbility() {
        super((Effect)new DrawDiscardControllerEffect(1, 1), Duration.EndOfTurn, false);
        this.setTriggerPhrase("Whenever one or more creatures you control deal combat damage to a player this turn, ");
    }

    private JaceCunningCastawayDamageTriggeredAbility(JaceCunningCastawayDamageTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public JaceCunningCastawayDamageTriggeredAbility copy() {
        return new JaceCunningCastawayDamageTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_ONE_PLAYER;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanent(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((DamagedBatchForOnePlayerEvent)event), game).isEmpty();
    }
}

