/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class JaceThePerfectedMindEffect
extends OneShotEffect {
    public JaceThePerfectedMindEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target player mills three cards. Then if a graveyard has twenty or more cards in it, you draw three cards. Otherwise, you draw a card.";
    }

    private JaceThePerfectedMindEffect(JaceThePerfectedMindEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaceThePerfectedMindEffect copy() {
        return new JaceThePerfectedMindEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Player sourcePlayer = game.getPlayer(source.getControllerId());
        int x = 1;
        targetPlayer.millCards(3, source, game);
        for (UUID playerId : game.getState().getPlayersInRange(sourcePlayer.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getGraveyard().size() < 20) continue;
            x = 3;
            break;
        }
        sourcePlayer.drawCards(x, source, game);
        return true;
    }
}

