/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class JacesArchivistEffect
extends OneShotEffect {
    JacesArchivistEffect() {
        super(Outcome.Discard);
        this.staticText = "Each player discards their hand, then draws cards equal to the greatest number of cards a player discarded this way";
    }

    private JacesArchivistEffect(JacesArchivistEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int maxDiscarded = 0;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player player;
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Cards discardedCards;
                player = game.getPlayer(playerId);
                if (player == null || (discardedCards = player.discard(player.getHand().size(), false, false, source, game)).size() <= maxDiscarded) continue;
                maxDiscarded = discardedCards.size();
            }
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                player = game.getPlayer(playerId);
                if (player == null) continue;
                player.drawCards(maxDiscarded, source, game);
            }
        }
        return true;
    }

    public JacesArchivistEffect copy() {
        return new JacesArchivistEffect(this);
    }
}

