/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterSpell;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class JacesDefeatEffect
extends OneShotEffect {
    private static final FilterSpell filter = new FilterSpell();

    public JacesDefeatEffect() {
        super(Outcome.Damage);
        this.staticText = "Counter target blue spell. If it was a Jace planeswalker spell, scry 2.";
    }

    private JacesDefeatEffect(JacesDefeatEffect effect) {
        super((OneShotEffect)effect);
    }

    public JacesDefeatEffect copy() {
        return new JacesDefeatEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
                Spell spell = game.getStack().getSpell(targetId);
                if (spell == null) continue;
                game.getStack().counter(targetId, source, game);
                Player controller = game.getPlayer(source.getControllerId());
                if (!filter.match((Object)spell, game) || controller == null) continue;
                controller.scry(2, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.PLANESWALKER.getPredicate());
        filter.add((Predicate)SubType.JACE.getPredicate());
    }
}

