/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.mana.ManaEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JackInTheMoxManaEffect
extends ManaEffect {
    JackInTheMoxManaEffect() {
        this.staticText = "roll a six-sided die. This ability has the indicated effect.<br>1 - Sacrifice {this} and you lose 5 life.<br>2 - Add {W}.<br>3 - Add {U}.<br>4 - Add {B}.<br>5 - Add {R}.<br>6 - Add {G}.";
    }

    private JackInTheMoxManaEffect(JackInTheMoxManaEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        return new ArrayList<Mana>();
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            switch (amount) {
                case 1: {
                    permanent.sacrifice(source, game);
                    controller.loseLife(5, game, source, false);
                    break;
                }
                case 2: {
                    mana.add(Mana.WhiteMana((int)1));
                    break;
                }
                case 3: {
                    mana.add(Mana.BlueMana((int)1));
                    break;
                }
                case 4: {
                    mana.add(Mana.BlackMana((int)1));
                    break;
                }
                case 5: {
                    mana.add(Mana.RedMana((int)1));
                    break;
                }
                case 6: {
                    mana.add(Mana.GreenMana((int)1));
                    break;
                }
            }
        }
        return mana;
    }

    public JackInTheMoxManaEffect copy() {
        return new JackInTheMoxManaEffect(this);
    }
}

