/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;

class JaddiLifestriderEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("untapped creatures you control");

    public JaddiLifestriderEffect() {
        super(Outcome.GainLife);
        this.staticText = "you may tap any number of untapped creatures you control. You gain 2 life for each creature tapped this way";
    }

    private JaddiLifestriderEffect(JaddiLifestriderEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        int tappedAmount = 0;
        Player you = game.getPlayer(source.getControllerId());
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, (FilterPermanent)filter, true);
        if (target.canChoose(source.getControllerId(), source, game) && target.choose(Outcome.Tap, source.getControllerId(), source.getSourceId(), source, game)) {
            for (UUID creatureId : target.getTargets()) {
                Permanent creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                creature.tap(source, game);
                ++tappedAmount;
            }
        }
        if (tappedAmount > 0 && you != null) {
            you.gainLife(tappedAmount * 2, game, source);
            return true;
        }
        return false;
    }

    public JaddiLifestriderEffect copy() {
        return new JaddiLifestriderEffect(this);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)TargetController.YOU.getControllerPredicate());
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

