/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ManaSpentDelayedTriggeredAbility;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class JadeOrbAdditionalCounterEffect
extends ReplacementEffectImpl {
    JadeOrbAdditionalCounterEffect() {
        super(Duration.EndOfTurn, Outcome.BoostCreature);
        this.staticText = "it enters the battlefield with an additional +1/+1 counter on it";
    }

    private JadeOrbAdditionalCounterEffect(JadeOrbAdditionalCounterEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!(source instanceof ManaSpentDelayedTriggeredAbility)) {
            return false;
        }
        GameEvent manaUsedEvent = ((ManaSpentDelayedTriggeredAbility)source).getTriggerEvent();
        Spell spell = game.getStack().getSpell(manaUsedEvent.getTargetId());
        if (spell == null) {
            return false;
        }
        return event.getSourceId().equals(spell.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        if (target != null) {
            target.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        }
        return false;
    }

    public JadeOrbAdditionalCounterEffect copy() {
        return new JadeOrbAdditionalCounterEffect(this);
    }
}

