/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class JarJarBinksTapEffect
extends OneShotEffect {
    JarJarBinksTapEffect() {
        super(Outcome.Tap);
        this.staticText = "tap the creature you control with the highest power. If two or more creatures are tied for the greatest power, you choose one of them";
    }

    private JarJarBinksTapEffect(JarJarBinksTapEffect effect) {
        super((OneShotEffect)effect);
    }

    public JarJarBinksTapEffect copy() {
        return new JarJarBinksTapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            int highestPower = Integer.MIN_VALUE;
            boolean multipleExist = false;
            Permanent permanentToTap = null;
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(), source.getControllerId(), game)) {
                if (permanent.getPower().getValue() > highestPower) {
                    permanentToTap = permanent;
                    highestPower = permanent.getPower().getValue();
                    multipleExist = false;
                    continue;
                }
                if (permanent.getPower().getValue() != highestPower) continue;
                multipleExist = true;
            }
            if (multipleExist) {
                FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("one of the creatures with the highest power");
                filter.add((Predicate)new PowerPredicate(ComparisonType.EQUAL_TO, highestPower));
                TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
                target.withNotTarget(true);
                if (target.canChoose(source.getControllerId(), source, game) && controller.choose(this.outcome, (Target)target, source, game)) {
                    permanentToTap = game.getPermanent(target.getFirstTarget());
                }
            }
            if (permanentToTap != null) {
                game.informPlayers(sourcePermanent.getName() + " chosen creature: " + permanentToTap.getName());
                return permanentToTap.tap(source, game);
            }
            return true;
        }
        return false;
    }
}

