/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class JaradsOrdersEffect
extends OneShotEffect {
    protected static final FilterCard filter = new FilterCard("card to put into your hand");

    public JaradsOrdersEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Search your library for up to two creature cards and reveal them. Put one into your hand and the other into your graveyard. Then shuffle";
    }

    private JaradsOrdersEffect(JaradsOrdersEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaradsOrdersEffect copy() {
        return new JaradsOrdersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            TargetCardInLibrary target = new TargetCardInLibrary(0, 2, (FilterCard)new FilterCreatureCard("creature cards"));
            if (controller.searchLibrary(target, source, game)) {
                if (!target.getTargets().isEmpty()) {
                    Card card;
                    CardsImpl revealed = new CardsImpl();
                    for (UUID cardId : target.getTargets()) {
                        Card card2 = controller.getLibrary().getCard(cardId, game);
                        revealed.add(card2);
                    }
                    controller.revealCards("Jarad's Orders", (Cards)revealed, game);
                    if (target.getTargets().size() == 2) {
                        TargetCard target2 = new TargetCard(Zone.LIBRARY, filter);
                        controller.choose(Outcome.Benefit, (Cards)revealed, target2, source, game);
                        card = revealed.get(target2.getFirstTarget(), game);
                        controller.moveCards(card, Zone.HAND, source, game);
                        revealed.remove(card);
                        Set cards = revealed.getCards(game);
                        card = cards.isEmpty() ? null : (Card)cards.iterator().next();
                        controller.moveCards(card, Zone.GRAVEYARD, source, game);
                    } else if (target.getTargets().size() == 1) {
                        Set cards = revealed.getCards(game);
                        card = cards.isEmpty() ? null : (Card)cards.iterator().next();
                        controller.moveCards(card, Zone.HAND, source, game);
                    }
                }
                controller.shuffleLibrary(source, game);
                return true;
            }
            controller.shuffleLibrary(source, game);
        }
        return false;
    }
}

