/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class JaredCarthalionUltimateEffect
extends OneShotEffect {
    JaredCarthalionUltimateEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return target multicolored card from your graveyard to your hand. If that card was all colors, draw a card and create two Treasure tokens.";
    }

    private JaredCarthalionUltimateEffect(JaredCarthalionUltimateEffect effect) {
        super((OneShotEffect)effect);
    }

    public JaredCarthalionUltimateEffect copy() {
        return new JaredCarthalionUltimateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && card != null && controller.moveCards(card, Zone.HAND, source, game) && card.getColor().getColorCount() == 5) {
            controller.drawCards(1, source, game);
            new TreasureToken().putOntoBattlefield(2, game, source);
            return true;
        }
        return false;
    }
}

