/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.j.JelevaNephaliasWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class JelevaNephaliasScourgeEffect
extends OneShotEffect {
    JelevaNephaliasScourgeEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles the top X cards of their library, where X is the amount of mana spent to cast this spell";
    }

    private JelevaNephaliasScourgeEffect(JelevaNephaliasScourgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public JelevaNephaliasScourgeEffect copy() {
        return new JelevaNephaliasScourgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        JelevaNephaliasWatcher watcher = (JelevaNephaliasWatcher)game.getState().getWatcher(JelevaNephaliasWatcher.class);
        if (controller == null || permanent == null || watcher == null) {
            return false;
        }
        int xValue = watcher.getManaSpentToCastLastTime(permanent.getId(), permanent.getZoneChangeCounter(game) - 1);
        if (xValue == 0) {
            return false;
        }
        boolean succeeded = false;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            succeeded |= player.moveCardsToExile(player.getLibrary().getTopCards(game, xValue), source, game, true, CardUtil.getCardExileZoneId((Game)game, (Ability)source), permanent.getIdName());
        }
        return succeeded;
    }
}

