/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class JodahTheUnifierEffect
extends OneShotEffect {
    JodahTheUnifierEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "exile cards from the top of your library until you exile a legendary nonland card with lesser mana value. You may cast that card without paying its mana cost. Put the rest on the bottom of your library in a random order.";
    }

    private JodahTheUnifierEffect(JodahTheUnifierEffect effect) {
        super((OneShotEffect)effect);
    }

    public JodahTheUnifierEffect copy() {
        return new JodahTheUnifierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Object spellCast = this.getValue("spellCast");
        if (!(spellCast instanceof Spell)) {
            return false;
        }
        int manaValue = ((Spell)spellCast).getManaValue();
        CardsImpl exiledCards = new CardsImpl();
        for (Card card : controller.getLibrary().getCards(game)) {
            exiledCards.add(card);
            controller.moveCards(card, Zone.EXILED, source, game);
            game.processAction();
            if (!card.isLegendary(game) || card.isLand(game) || card.getManaValue() >= manaValue) continue;
            CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
            break;
        }
        exiledCards.retainZone(Zone.EXILED, game);
        controller.putCardsOnBottomOfLibrary((Cards)exiledCards, game, source, false);
        return true;
    }
}

