/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.OnceEachTurnCastWatcher;

class JohannApprenticeSorcererPlayTopEffect
extends AsThoughEffectImpl {
    JohannApprenticeSorcererPlayTopEffect() {
        super(AsThoughEffectType.CAST_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Once each turn, you may cast an instant or sorcery spell from the top of your library";
    }

    private JohannApprenticeSorcererPlayTopEffect(JohannApprenticeSorcererPlayTopEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public JohannApprenticeSorcererPlayTopEffect copy() {
        return new JohannApprenticeSorcererPlayTopEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        throw new IllegalArgumentException("Wrong code usage: can't call applies method on empty affectedAbility");
    }

    public boolean applies(UUID objectId, Ability affectedAbility, Ability source, Game game, UUID playerId) {
        Player controller = game.getPlayer(source.getControllerId());
        OnceEachTurnCastWatcher watcher = (OnceEachTurnCastWatcher)game.getState().getWatcher(OnceEachTurnCastWatcher.class);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (controller == null || sourcePermanent == null || watcher == null) {
            return false;
        }
        if (!playerId.equals(source.getControllerId())) {
            return false;
        }
        if (watcher.isAbilityUsed(controller.getId(), new MageObjectReference((MageObject)sourcePermanent, game))) {
            return false;
        }
        Card card = game.getCard(objectId);
        Card topCard = controller.getLibrary().getFromTop(game);
        if (card == null || topCard == null || !topCard.getId().equals(card.getMainCard().getId())) {
            return false;
        }
        if (affectedAbility instanceof SpellAbility) {
            SpellAbility spellAbility = (SpellAbility)affectedAbility;
            if (spellAbility.getManaCosts().isEmpty() || !spellAbility.spellCanBeActivatedNow(playerId, game).contains(MageIdentifier.Default)) {
                return false;
            }
            Card cardToCheck = spellAbility.getCharacteristics(game);
            return cardToCheck.isInstantOrSorcery(game);
        }
        return false;
    }
}

