/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.UntapSourceEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class JokulmorderTriggeredAbility
extends TriggeredAbilityImpl {
    JokulmorderTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new UntapSourceEffect(), true);
    }

    private JokulmorderTriggeredAbility(JokulmorderTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.LAND_PLAYED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent land = game.getPermanent(event.getTargetId());
        return land != null && land.hasSubtype(SubType.ISLAND, game) && land.isControlledBy(this.controllerId);
    }

    public JokulmorderTriggeredAbility copy() {
        return new JokulmorderTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you play an Island, you may untap {this}.";
    }
}

