/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.j.JourneyForTheElixirTarget;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class JourneyForTheElixirEffect
extends OneShotEffect {
    JourneyForTheElixirEffect() {
        super(Outcome.Benefit);
        this.staticText = "Search your library and graveyard for a basic land card and a card named Jiang Yanggu, reveal them, put them into your hand, then shuffle.";
    }

    private JourneyForTheElixirEffect(JourneyForTheElixirEffect effect) {
        super((OneShotEffect)effect);
    }

    public JourneyForTheElixirEffect copy() {
        return new JourneyForTheElixirEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl allCards = new CardsImpl();
        allCards.addAll((Collection)controller.getLibrary().getCardList());
        allCards.addAll((Collection)controller.getGraveyard());
        JourneyForTheElixirTarget target = new JourneyForTheElixirTarget();
        if (controller.choose(Outcome.Benefit, (Cards)allCards, (TargetCard)target, source, game)) {
            CardsImpl cards = new CardsImpl((Collection)target.getTargets());
            controller.revealCards(source, (Cards)cards, game);
            controller.moveCards((Cards)cards, Zone.HAND, source, game);
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }
}

