/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.SuperType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.NamePredicate;
import mage.game.Game;
import mage.target.TargetCard;

class JourneyForTheElixirTarget
extends TargetCard {
    private static final String name = "Jiang Yanggu";
    private static final FilterCard filter = new FilterCard("a basic land card and a card named Jiang Yanggu");

    JourneyForTheElixirTarget() {
        super(2, 2, Zone.ALL, filter);
    }

    private JourneyForTheElixirTarget(JourneyForTheElixirTarget target) {
        super((TargetCard)target);
    }

    public JourneyForTheElixirTarget copy() {
        return new JourneyForTheElixirTarget(this);
    }

    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        Card card = game.getCard(id);
        if (card == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl((Collection)this.getTargets());
        boolean hasLand = cards.getCards(game).stream().filter(Objects::nonNull).filter(c -> c.isBasic(game)).anyMatch(c -> c.isLand(game));
        boolean hasJiang = cards.getCards(game).stream().map(MageObject::getName).anyMatch(name::equals);
        if (!hasLand && card.isBasic(game) && card.isLand(game)) {
            return true;
        }
        return !hasJiang && name.equals(card.getName());
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        possibleTargets.removeIf(uuid -> !this.canTarget(sourceControllerId, (UUID)uuid, source, game));
        return possibleTargets;
    }

    static {
        filter.add(Predicates.or((Predicate)Predicates.and((Predicate)SuperType.BASIC.getPredicate(), (Predicate)CardType.LAND.getPredicate()), (Predicate)new NamePredicate(name)));
    }
}

