/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.stack.Spell;

class JudithCarnageConnoisseurEffect
extends ContinuousEffectImpl {
    JudithCarnageConnoisseurEffect() {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
        this.staticText = "That spell gains deathtouch and lifelink";
    }

    private JudithCarnageConnoisseurEffect(JudithCarnageConnoisseurEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public JudithCarnageConnoisseurEffect copy() {
        return new JudithCarnageConnoisseurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (spell == null) {
            this.discard();
            return false;
        }
        Card card = spell.getCard();
        game.getState().addOtherAbility(card, (Ability)DeathtouchAbility.getInstance());
        game.getState().addOtherAbility(card, (Ability)LifelinkAbility.getInstance());
        return true;
    }
}

