/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class JumboImpAddCountersEffect
extends OneShotEffect {
    JumboImpAddCountersEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die and put a number of +1/+1 counters on {this} equal to the result";
    }

    private JumboImpAddCountersEffect(JumboImpAddCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public JumboImpAddCountersEffect copy() {
        return new JumboImpAddCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int amount = controller.rollDice(this.outcome, source, game, 6);
            permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

