/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.j;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class KaldringTheRimestaffTapEffect
extends ReplacementEffectImpl {
    private final UUID cardId;

    public KaldringTheRimestaffTapEffect(UUID cardId) {
        super(Duration.EndOfTurn, Outcome.Tap);
        this.cardId = cardId;
    }

    private KaldringTheRimestaffTapEffect(KaldringTheRimestaffTapEffect effect) {
        super((ReplacementEffectImpl)effect);
        this.cardId = effect.cardId;
    }

    public KaldringTheRimestaffTapEffect copy() {
        return new KaldringTheRimestaffTapEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent target = ((EntersTheBattlefieldEvent)event).getTarget();
        if (target != null) {
            target.setTapped(true);
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.cardId);
    }
}

