/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetImpl;
import mage.target.TargetPermanent;

class AutumnTailEffect
extends OneShotEffect {
    AutumnTailEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "attach target Aura attached to a creature to another creature";
    }

    private AutumnTailEffect(AutumnTailEffect effect) {
        super((OneShotEffect)effect);
    }

    public AutumnTailEffect copy() {
        return new AutumnTailEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent aura = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || aura == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add(Predicates.not((Predicate)new PermanentIdPredicate(aura.getAttachedTo())));
        if (!game.getBattlefield().contains((FilterPermanent)filter, source.getControllerId(), source, game, 1)) {
            return false;
        }
        TargetPermanent target = new TargetPermanent((FilterPermanent)filter);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        return Optional.ofNullable(target).map(TargetImpl::getFirstTarget).map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(permanent -> permanent.addAttachment(aura.getId(), source, game)).isPresent();
    }
}

