/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class DamagedByEnchantedWatcher
extends Watcher {
    private final Set<MageObjectReference> damagedCreatures = new HashSet<MageObjectReference>();

    public DamagedByEnchantedWatcher() {
        super(WatcherScope.CARD);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        Permanent enchantment;
        if (event.getType() == GameEvent.EventType.DAMAGED_PERMANENT && (enchantment = game.getPermanent(this.getSourceId())) != null && enchantment.isAttachedTo(event.getSourceId()) && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isCreature(game)) {
            MageObjectReference mor = new MageObjectReference(event.getTargetId(), game);
            this.damagedCreatures.add(mor);
        }
    }

    public void reset() {
        super.reset();
        this.damagedCreatures.clear();
    }

    public boolean wasDamaged(Permanent permanent, Game game) {
        return this.damagedCreatures.contains(new MageObjectReference((MageObject)permanent, game));
    }
}

