/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class KadenaSlinkingSorcererWatcher
extends Watcher {
    private final Set<UUID> castFaceDown = new HashSet<UUID>();

    KadenaSlinkingSorcererWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = (Spell)game.getObject(event.getTargetId());
        if (spell == null || !spell.isCreature(game) || !spell.isFaceDown(game)) {
            return;
        }
        this.castFaceDown.add(event.getPlayerId());
    }

    boolean castFaceDownThisTurn(UUID playerId) {
        return this.castFaceDown.contains(playerId);
    }

    public void reset() {
        super.reset();
        this.castFaceDown.clear();
    }
}

