/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class KaervekTheMercilessEffect
extends OneShotEffect {
    KaervekTheMercilessEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals damage equal to that spell's mana value to any target";
    }

    private KaervekTheMercilessEffect(KaervekTheMercilessEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaervekTheMercilessEffect copy() {
        return new KaervekTheMercilessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        if (spell != null) {
            int cost = spell.getManaValue();
            Player target = game.getPlayer(source.getFirstTarget());
            if (target != null) {
                target.damage(cost, source.getSourceId(), source, game);
                return true;
            }
            Permanent targetCreature = game.getPermanent(source.getFirstTarget());
            if (targetCreature != null) {
                targetCreature.damage(cost, source.getSourceId(), source, game, false, true);
                return true;
            }
        }
        return false;
    }
}

