/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class KaerveksPurgeEffect
extends OneShotEffect {
    KaerveksPurgeEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature with mana value X. If that creature dies this way, {this} deals damage equal to the creature's power to the creature's controller";
    }

    private KaerveksPurgeEffect(KaerveksPurgeEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaerveksPurgeEffect copy() {
        return new KaerveksPurgeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null && targetCreature.destroy(source, game, false)) {
            game.processAction();
            if (targetCreature.getZoneChangeCounter(game) + 1 == game.getState().getZoneChangeCounter(targetCreature.getId()) && game.getState().getZone(targetCreature.getId()) != Zone.GRAVEYARD) {
                return true;
            }
            Player creatureController = game.getPlayer(targetCreature.getControllerId());
            int power = targetCreature.getPower().getValue();
            if (creatureController != null) {
                creatureController.damage(power, source.getSourceId(), source, game);
            }
        }
        return true;
    }
}

