/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.HashSet;
import java.util.Set;
import mage.MageIdentifier;
import mage.MageObject;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class KaghaShadowArchdruidWatcher
extends Watcher {
    private final Set<MageObjectReference> usedFrom = new HashSet<MageObjectReference>();
    private final Set<MageObjectReference> morSet = new HashSet<MageObjectReference>();

    KaghaShadowArchdruidWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        ZoneChangeEvent zEvent;
        if ((GameEvent.EventType.SPELL_CAST.equals((Object)event.getType()) || GameEvent.EventType.LAND_PLAYED.equals((Object)event.getType())) && event.hasApprovingIdentifier(MageIdentifier.KaghaShadowArchdruidWatcher)) {
            this.usedFrom.add(event.getApprovingObject().getApprovingMageObjectReference());
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && (zEvent = (ZoneChangeEvent)event).getFromZone() == Zone.LIBRARY && zEvent.getToZone() == Zone.GRAVEYARD) {
            this.morSet.add(new MageObjectReference(zEvent.getTargetId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.usedFrom.clear();
        this.morSet.clear();
    }

    boolean abilityNotUsed(MageObjectReference mor) {
        return !this.usedFrom.contains(mor);
    }

    boolean checkCard(Card card, Game game) {
        return this.morSet.stream().anyMatch(mor -> mor.refersTo((MageObject)card, game));
    }
}

