/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Collection;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class KahoMinamoHistorianEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard("up to three instant cards");

    public KahoMinamoHistorianEffect() {
        super(new TargetCardInLibrary(0, 3, filter), Outcome.Benefit);
        this.staticText = "search your library for up to three instant cards, exile them, then shuffle";
    }

    private KahoMinamoHistorianEffect(KahoMinamoHistorianEffect effect) {
        super((SearchEffect)effect);
    }

    public KahoMinamoHistorianEffect copy() {
        return new KahoMinamoHistorianEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller != null && sourceObject != null) {
            if (controller.searchLibrary(this.target, source, game)) {
                UUID exileZone = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
                if (!this.target.getTargets().isEmpty()) {
                    controller.moveCardsToExile(new CardsImpl((Collection)this.target.getTargets()).getCards(game), source, game, true, exileZone, sourceObject.getIdName());
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CardType.INSTANT.getPredicate());
    }
}

