/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.k;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class KaimaTheFracturedCalmEffect
extends OneShotEffect {
    KaimaTheFracturedCalmEffect() {
        super(Outcome.Benefit);
        this.staticText = "goad each creature your opponents control that's enchanted by an Aura you control. Put a +1/+1 counter on {this} for each creature goaded this way";
    }

    private KaimaTheFracturedCalmEffect(KaimaTheFracturedCalmEffect effect) {
        super((OneShotEffect)effect);
    }

    public KaimaTheFracturedCalmEffect copy() {
        return new KaimaTheFracturedCalmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int goaded = 0;
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_OPPONENTS_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getAttachments().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).noneMatch(p -> p.isControlledBy(source.getControllerId()) && p.hasSubtype(SubType.AURA, game))) continue;
            game.addEffect(new GoadTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            ++goaded;
        }
        if (goaded < 1) {
            return false;
        }
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null) {
            permanent.addCounters(CounterType.P1P1.createInstance(goaded), source, game);
        }
        return true;
    }
}

